Attribute VB_Name = "BookEx"
Option Explicit

'API functions
Public Declare Function GetClassLong Lib "user32" Alias "GetClassLongA" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Public Declare Function GetClassName Lib "user32" Alias "GetClassNameA" (ByVal hwnd As Long, ByVal lpClassName As String, ByVal nMaxCount As Long) As Long
Public Declare Function GetClassInfoEx Lib "user32" Alias "GetClassInfoExA" (ByVal hInstance As Long, ByVal lpClassName As String, lpWndClass As WNDCLASSEX) As Long
Public Declare Function RegisterClassEx Lib "user32" Alias "RegisterClassExA" (pcWndClassEx As WNDCLASSEX) As Integer
Public Declare Function UnregisterClass Lib "user32" Alias "UnregisterClassA" (ByVal lpClassName As String, ByVal hInstance As Long) As Long

Public Declare Function GetMessage Lib "user32" Alias "GetMessageA" (lpMsg As Msg, ByVal hwnd As Long, ByVal wMsgFilterMin As Long, ByVal wMsgFilterMax As Long) As Long
Public Declare Function IsDialogMessage Lib "user32" Alias "IsDialogMessageA" (ByVal hDlg As Long, lpMsg As Msg) As Long
Public Declare Function TranslateMessage Lib "user32" (lpMsg As Msg) As Long
Public Declare Function DispatchMessage Lib "user32" Alias "DispatchMessageA" (lpMsg As Msg) As Long
Public Declare Function TranslateAccelerator Lib "user32" Alias "TranslateAcceleratorA" (ByVal hwnd As Long, ByVal hAccTable As Long, lpMsg As Msg) As Long

Public Declare Function LoadCursor Lib "user32" Alias "LoadCursorA" (ByVal hInstance As Long, ByVal lpCursorName As Any) As Long
Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)

Public Declare Function CreateWindowEx Lib "user32" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, lpParam As Any) As Long
Public Declare Function ShowWindow Lib "user32" (ByVal hwnd As Long, ByVal nCmdShow As Long) As Long

Public Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Public Declare Function DefWindowProc Lib "user32" Alias "DefWindowProcA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

Public Declare Function DestroyWindow Lib "user32" (ByVal hwnd As Long) As Long
Public Declare Sub PostQuitMessage Lib "user32" (ByVal nExitCode As Long)


'Structures
Public Type WNDCLASSEX
    cbSize As Long
    style As Long
    lpfnWndProc As Long
    cbClsExtra As Long
    cbWndExtra As Long
    hInstance As Long
    hIcon As Long
    hCursor As Long
    hbrBackground As Long
    lpszMenuName As String
    lpszClassName As String
    hIconSm As Long
End Type

Public Type POINTAPI
    x As Long
    y As Long
End Type

Public Type Msg
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type

Public Type HACCEL
        fVirt As Byte
        key As Integer
        cmd As Integer
End Type


'Constants
Public Const CS_VREDRAW = &H1
Public Const CS_HREDRAW = &H2
Public Const CS_PARENTDC = &H80
Public Const CS_DBLCLKS = &H8

Public Const WS_DISABLED = &H8000000
Public Const WS_TABSTOP = &H10000
Public Const WS_BORDER = &H800000
Public Const WS_CHILD = &H40000000
Public Const WS_OVERLAPPED = &H0&
Public Const WS_CAPTION = &HC00000 ' WS_BORDER Or WS_DLGFRAME
Public Const WS_SYSMENU = &H80000
Public Const WS_THICKFRAME = &H40000
Public Const WS_MINIMIZEBOX = &H20000
Public Const WS_MAXIMIZEBOX = &H10000
Public Const WS_OVERLAPPEDWINDOW = (WS_OVERLAPPED Or WS_CAPTION Or WS_SYSMENU Or WS_THICKFRAME Or WS_MINIMIZEBOX Or WS_MAXIMIZEBOX)
Public Const WS_VISIBLE = &H10000000

Public Const WM_DESTROY = &H2
Public Const WM_LBUTTONDOWN = &H201
Public Const WM_LBUTTONUP = &H202
Public Const IDC_ARROW = 32512&
Public Const IDC_UPARROW = 32516&
Public Const GWL_WNDPROC = (-4)
Public Const SW_SHOWNORMAL = 1
Public Const COLOR_WINDOW = 7
Public Const CW_USEDEFAULT = &H80000000
Public Const BS_PUSHBUTTON = &H0&
Public Const GCL_HMODULE = (-16)


'Module Scope Const
Private Const SCButtonClassName = "NewBttnClass"
Private Const WindowClassName = "NewMainWndClass"


'Module Scope Vars
Private m_hwndMain As Long
'Private m_hwndSCBttn As Long
'Private m_hwndModalDlg As Long

Private m_OrigBttnWinProc As Long
Private m_OrigWinProc As Long

Private m_CreatedWndHandles() As Long


Public Sub Main()
    Dim structMsg As Msg
    Dim structAccel As Long   'HACCEL
    
    'Initialization
'    m_hwndModalDlg = 0          'No modal dialogs in this application
    structAccel = 0             'No accelerator tables in this project
    ReDim m_CreatedWndHandles(0)
    
    'Create window to steal class info from
    Load Form1
    
    'Registration
    'Register main window
    If RegisterFormClass = True Then
        'Register button superclass
        If RegisterButtonClass = True Then
            'Creation
            If CreateMainWindow = True Then             'Create main window
                If CreateSuperClsBttn = True Then       'Create button superclass
                    'Message loop (Message pump)
                    Do While GetMessage(structMsg, 0&, 0&, 0&)
                        If Not (TranslateAccelerator(structMsg.hwnd, structAccel, structMsg)) Then
                            If Not (IsDialogMessage(0, structMsg)) Then
                                Call TranslateMessage(structMsg)
                                Call DispatchMessage(structMsg)
                            End If
                        End If
                    Loop
                End If
            End If
        
            'Clean up
            Call UnregisterClass(SCButtonClassName, App.hInstance)
            Call UnregisterClass(WindowClassName, App.hInstance)
        End If
    End If
    
    Unload Form1
End Sub



'----------------------------------
'-  Main Window
'----------------------------------

Private Function RegisterFormClass() As Boolean
    Dim structOrigWinClass As WNDCLASSEX
    Dim structWinClass As WNDCLASSEX
    Dim lretval As Long
    Dim sClassName As String * 100
    Dim lRetLength As Long
    Dim myhInst As Long
    
    'Using the thunder class name directly only works in the IDE,
    '   because in the IDE the hInstance values are the same
    '   for the thunder class and app.hInstance
    '   EX.   lRetVal = GetClassInfoEx(App.hInstance, "ThunderFormDC", structOrigWinClass)
    lRetLength = GetClassName(Form1.hwnd, sClassName, 100)
    myhInst = GetClassLong(Form1.hwnd, GCL_HMODULE)
    lretval = GetClassInfoEx(myhInst, Left$(sClassName, lRetLength), structOrigWinClass)
    If lretval = 0 Then
        MsgBox "Error in getting original form class information: " & Err.LastDllError
        RegisterFormClass = False
    Else
        'Get a copy of its elements
        CopyMemory structWinClass, structOrigWinClass, LenB(structOrigWinClass)
        
        'Get original button window procedure and save it
        m_OrigWinProc = structWinClass.lpfnWndProc
        
        'Place the original element values into the new superclassed button class
        With structWinClass
            .cbSize = LenB(structWinClass)
            .lpszClassName = WindowClassName
            .lpfnWndProc = GetProcAddr(AddressOf MainWndProc) 'Window procedure address
            .hInstance = App.hInstance
            .hCursor = LoadCursor(0, IDC_UPARROW)
            '.style =           -> Add/Remove class styles here
            '.hbrBackground =   -> Change background color here
            '.hIcon             -> Use LoadIcon API function
            '.lpszMenuName      -> No menu is associate with this window
            '.cbClsextra        -> Add extra class bytes here
            '.cbWndExtra2       -> Add extra window bytes here
        End With
        
        'Register this class
        If RegisterClassEx(structWinClass) <> 0 Then
            RegisterFormClass = True
        Else
            RegisterFormClass = False
        End If
    End If
End Function

Private Function CreateMainWindow() As Boolean
    'Create main window
    m_hwndMain = CreateWindowEx(0, WindowClassName, "Main Window", WS_OVERLAPPEDWINDOW, _
            CW_USEDEFAULT, CW_USEDEFAULT, 208, 150, 0, 0, CLng(App.hInstance), ByVal 0)

    If m_hwndMain > 0 Then
        'Show main window
        Call ShowWindow(m_hwndMain, SW_SHOWNORMAL)
        CreateMainWindow = True
    Else
        MsgBox "Main window could not be created"
        CreateMainWindow = False
    End If
End Function

Public Function MainWndProc(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    Dim Count As Long
    
    Select Case uMsg
        Case WM_LBUTTONDOWN
            MsgBox "Window: " & hwnd & " was clicked."
        Case WM_DESTROY:
            'If we are destroying the main window
            '  then we will want to end the application
            If hwnd = m_hwndMain Then
                'Make sure all windows are removed - this is
                '   so the UnRegisterClass functions will remove
                '   our new classes from memory correctly
                For Count = 0 To UBound(m_CreatedWndHandles) - 1
                    DestroyWindow (m_CreatedWndHandles(Count))
                Next
            
                'Exit the message loop and Stop the application
                Call PostQuitMessage(0&)
            End If
            Exit Function
    End Select
    
    'Let the main window behave as a normal window
    MainWndProc = DefWindowProc(hwnd, uMsg, wParam, lParam)
End Function



'----------------------------------
'-  SuperClassed Button
'----------------------------------

Private Function RegisterButtonClass() As Boolean
    Dim structOrigBttnClass As WNDCLASSEX
    Dim structBttnSuperClass As WNDCLASSEX
    Dim lretval As Long
    
    'Get original Window's button class
    lretval = GetClassInfoEx(0, "BUTTON", structOrigBttnClass)
    If lretval = 0 Then
        MsgBox "Error in getting original button class information"
        RegisterButtonClass = False
    Else
        'Get a copy of its elements
        CopyMemory structBttnSuperClass, structOrigBttnClass, LenB(structOrigBttnClass)
        
        'Get original button window procedure and save it
        m_OrigBttnWinProc = structBttnSuperClass.lpfnWndProc
        
        'Place the original element values into the new superclassed button class
        With structBttnSuperClass
            .cbSize = LenB(structBttnSuperClass)
            .lpszClassName = SCButtonClassName
            .hInstance = App.hInstance
            .lpfnWndProc = GetProcAddr(AddressOf ButtonWndProc)       'Window procedure address
            '.lpszMenuName       -> This window does not use a menu
        End With
        
        'Register the class
        If RegisterClassEx(structBttnSuperClass) <> 0 Then
            RegisterButtonClass = True
        Else
            RegisterButtonClass = False
        End If
    End If
End Function

Private Function CreateSuperClsBttn() As Boolean
    Dim m_hwndSCBttn As Long
    
    'Create superclassed button
    m_hwndSCBttn = CreateWindowEx(0, SCButtonClassName, "Click Me", WS_CHILD Or WS_VISIBLE Or BS_PUSHBUTTON, _
            58, 90, 85, 25, m_hwndMain, 0, CLng(App.hInstance), 0)

    'Show the button
    If m_hwndSCBttn > 0 Then
        Call ShowWindow(m_hwndSCBttn, SW_SHOWNORMAL)
        CreateSuperClsBttn = True
    Else
        MsgBox "Superclassed button could not be created"
        CreateSuperClsBttn = False
    End If
End Function

Public Function ButtonWndProc(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    Dim tempHwnd As Long
    Dim tempButtonHwnd As Long
    
    Select Case uMsg&
        Case WM_LBUTTONUP:
            'Create a new window with the superclassed button on it
            tempHwnd = CreateWindowEx(0, WindowClassName, "New Window", WS_OVERLAPPEDWINDOW, _
                    CW_USEDEFAULT, CW_USEDEFAULT, 208, 150, 0, 0, CLng(App.hInstance), ByVal 0)
            
            tempButtonHwnd = CreateWindowEx(0, SCButtonClassName, "Click Me", WS_CHILD Or WS_VISIBLE Or BS_PUSHBUTTON, _
                    58, 90, 85, 25, tempHwnd, 0, CLng(App.hInstance), 0)
            
            'Show all new windows
            Call ShowWindow(tempHwnd, SW_SHOWNORMAL)
            Call ShowWindow(tempButtonHwnd, SW_SHOWNORMAL)
            
            'Add this windows hwnd to the list of created windows
            m_CreatedWndHandles(UBound(m_CreatedWndHandles)) = tempHwnd
            ReDim Preserve m_CreatedWndHandles(UBound(m_CreatedWndHandles) + 1)
    End Select
    
    'Pass messages on to original button window procedure
    ButtonWndProc = CallWindowProc(m_OrigBttnWinProc, hwnd, uMsg, wParam, lParam)
End Function




'----------------------------------
'-  Helper Functions
'----------------------------------

Public Function GetProcAddr(ByVal lAddr As Long) As Long
    GetProcAddr = lAddr
End Function

